/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.util.ItemStackUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class ContainerRack
extends Container {
    private final IItemHandler inventory;
    public final AbstractTileEntityRack rack;
    public final AbstractTileEntityRack neighborRack;
    private final int inventorySize;

    public static ContainerRack fromPacketBuffer(int windowId, PlayerInventory inv, PacketBuffer packetBuffer) {
        BlockPos tePos = packetBuffer.func_179259_c();
        BlockPos neighborPos = packetBuffer.func_179259_c();
        return new ContainerRack(windowId, inv, tePos, neighborPos);
    }

    public ContainerRack(int windowId, PlayerInventory inv, BlockPos rack, BlockPos neighbor) {
        super(ModContainers.rackInv, windowId);
        int i;
        AbstractTileEntityRack neighborRack;
        AbstractTileEntityRack abstractTileEntityRack = (AbstractTileEntityRack)inv.field_70458_d.field_70170_p.func_175625_s(rack);
        AbstractTileEntityRack abstractTileEntityRack2 = neighborRack = neighbor.equals((Object)BlockPos.field_177992_a) ? null : (AbstractTileEntityRack)inv.field_70458_d.field_70170_p.func_175625_s(neighbor);
        this.inventory = neighborRack != null ? (abstractTileEntityRack.isMain() ? new CombinedInvWrapper(new IItemHandlerModifiable[]{abstractTileEntityRack.getInventory(), neighborRack.getInventory()}) : new CombinedInvWrapper(new IItemHandlerModifiable[]{neighborRack.getInventory(), abstractTileEntityRack.getInventory()})) : abstractTileEntityRack.getInventory();
        this.rack = abstractTileEntityRack;
        this.neighborRack = neighborRack;
        this.inventorySize = this.inventory.getSlots() / 9;
        int size = this.inventory.getSlots();
        int columns = this.inventorySize <= 8 ? 9 : size / 8 + 1;
        int extraOffset = this.inventorySize <= 8 ? 0 : 2;
        int index = 0;
        for (int j = 0; j < Math.min(this.inventorySize, 8); ++j) {
            for (int k = 0; k < columns; ++k) {
                if (index >= size) continue;
                this.func_75146_a((Slot)new SlotItemHandler(this.inventory, index, 8 + k * 18, 18 + j * 18));
                ++index;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inv, j + i * 9 + 9, 8 + j * 18, 30 + extraOffset + 18 * Math.min(this.inventorySize, 8) + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inv, i, 8 + i * 18, 88 + extraOffset + 18 * Math.min(this.inventorySize, 8)));
        }
    }

    @NotNull
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (player.field_70170_p.field_72995_K || slotId >= this.inventory.getSlots() || slotId < 0) {
            return super.func_184996_a(slotId, dragType, clickTypeIn, player);
        }
        ItemStack currentStack = this.inventory.getStackInSlot(slotId).func_77946_l();
        ItemStack result = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        ItemStack afterStack = this.inventory.getStackInSlot(slotId).func_77946_l();
        if (!ItemStack.func_77989_b((ItemStack)currentStack, (ItemStack)afterStack)) {
            this.updateRacks(afterStack);
        }
        return result;
    }

    @NotNull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStackUtils.EMPTY;
        }
        ItemStack stackCopy = slot.func_75211_c().func_77946_l();
        int maxIndex = this.inventorySize * 9;
        if (index < maxIndex ? !this.func_75135_a(stackCopy, maxIndex, this.field_75151_b.size(), true) : !this.func_75135_a(stackCopy, 0, maxIndex, false)) {
            return ItemStackUtils.EMPTY;
        }
        if (ItemStackUtils.getSize(stackCopy) == 0) {
            slot.func_75215_d(ItemStackUtils.EMPTY);
        } else {
            slot.func_75215_d(stackCopy);
            slot.func_75218_e();
        }
        if (playerIn instanceof ServerPlayerEntity) {
            this.updateRacks(stackCopy);
        }
        return stackCopy;
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack before = stack.func_77946_l();
        boolean merge = super.func_75135_a(stack, startIndex, endIndex, reverseDirection);
        if (merge) {
            this.updateRacks(before);
        }
        return merge;
    }

    private void updateRacks(ItemStack stack) {
        this.rack.updateItemStorage();
        this.rack.updateWarehouseIfAvailable(stack);
        if (this.neighborRack != null) {
            this.neighborRack.updateItemStorage();
            this.neighborRack.updateWarehouseIfAvailable(stack);
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }
}

